#pragma once
#include "../wii/wiimote.h"
#include "../../tools/Mutex.h"
#include <mmsystem.h>	// for timeGetTime
#include <math.h>

#define pi 3.1415926535897932384626433832795028841971693992

class wii
{
public:
	wii(void);
	~wii(void);

    int startwiimote(void);
	int stopwiimote(void);
	bool RcvThreadRun;
	void RcvThread(void);
	static UINT RcvThread(LPVOID p);
	Mutex WiiMutex;
	float wiix,wiiy;
	CPoint GetWiiVal();
	// create a wiimote object
	wiimote wiimote;
	bool first;

	// (stuff for animations)
	DWORD	 last_rumble_time;
	DWORD    last_led_time;
	bool	 rumble_text;
	unsigned lit_led;

	int initfilter(void);
	int runfilter(void);
/**************************************************************************

FILTER.C - Source code for filter functions

    iir_filter         IIR filter floats sample by sample (real time)

*************************************************************************/

/* FILTER INFORMATION STRUCTURE FOR FILTER ROUTINES */

typedef struct {
    unsigned int length;       /* size of filter */
    float *history;            /* pointer to history in filter */
    float *coef;               /* pointer to coefficients of filter */
} FILTER;

#define FILTER_SECTIONS   2   /* 2 filter sections for 24 db/oct filter */

typedef struct {
        double a0, a1, a2;       /* numerator coefficients */
        double b0, b1, b2;       /* denominator coefficients */
} BIQUAD;

BIQUAD ProtoCoef[FILTER_SECTIONS];      /* Filter prototype coefficients,
                                                     1 for each filter section */

void szxform(
    double *a0, double *a1, double *a2,     /* numerator coefficients */
    double *b0, double *b1, double *b2,   /* denominator coefficients */
    double fc,           /* Filter cutoff frequency */
    double fs,           /* sampling rate */
    double *k,           /* overall gain factor */
    float *coef);         /* pointer to 4 iir coefficients */




void prewarp(double *a0, double *a1, double *a2, double fc, double fs);
void bilinear(
    double a0, double a1, double a2,    /* numerator coefficients */
    double b0, double b1, double b2,    /* denominator coefficients */
    double *k,                                   /* overall gain factor */
    double fs,                                   /* sampling rate */
    float *coef);                         /* pointer to 4 iir coefficients */

float iir_filter(float,FILTER*);


		FILTER   iir1,iir2;
        float    *coef1;
        double   fs1, fc1;     /* Sampling frequency, cutoff frequency */
        double   Q1;     /* Resonance > 1.0 < 1000 */
        unsigned nInd1;
        double   a0_1, a1_1, a2_1, b0_1, b1_1, b2_1;
        double   k1;           /* overall gain factor */

		float    *coef2;
        double   fs2, fc2;     /* Sampling frequency, cutoff frequency */
        double   Q2;     /* Resonance > 1.0 < 1000 */
        unsigned nInd2;
        double   a0_2, a1_2, a2_2, b0_2, b1_2, b2_2;
        double   k2;           /* overall gain factor */
/**************************************************************************
*************************************************************************/
};
